//
//  PersistenceViewController.m
//  Persistence
//
//  Created by Robert Górczyński on 11-07-15.
//

#import "PersistenceViewController.h"
#import "FourLines.h" 
#import <sqlite3.h> 

@implementation PersistenceViewController
@synthesize field1; 
@synthesize field2; 
@synthesize field3; 
@synthesize field4; 

- (NSString *)dataFilePath { 
    NSArray *paths = NSSearchPathForDirectoriesInDomains( 
														 NSDocumentDirectory, NSUserDomainMask, YES); 
    NSString *documentsDirectory = [paths objectAtIndex:0]; 
    return [documentsDirectory stringByAppendingPathComponent:kFilename]; 
} 

#pragma mark - 
- (void)viewDidLoad { 
	sqlite3 *database; 
	if (sqlite3_open([[self dataFilePath] UTF8String], &database) 
		!= SQLITE_OK) { 
		sqlite3_close(database); 
		NSAssert(0, @"Nie udało się otworzyć bazy danych"); 
	} 
	
	char *errorMsg; 
	// Warto zauważyć, że poniższe polecenie powinno zostać zapisane w pojedynczym wierszu... 
	NSString *createSQL = @"CREATE TABLE IF NOT EXISTS FIELDS (ROW INTEGER PRIMARY KEY, FIELD_DATA TEXT);"; 
	if (sqlite3_exec (database, [createSQL UTF8String], 
					  NULL, NULL, &errorMsg) != SQLITE_OK) { 
		sqlite3_close(database); 
		NSAssert1(0, @"Błąd podczas tworzenia tabeli: %s", errorMsg); 
	} 
	NSString *query = @"SELECT ROW, FIELD_DATA FROM FIELDS ORDER BY ROW"; 
	sqlite3_stmt *statement; 
	if (sqlite3_prepare_v2(database, [query UTF8String], 
						   -1, &statement, nil) == SQLITE_OK) { 
		while (sqlite3_step(statement) == SQLITE_ROW) { 
			int row = sqlite3_column_int(statement, 0); 
			char *rowData = (char *)sqlite3_column_text(statement, 1); 
			
			NSString *fieldName = [[NSString alloc] 
								   initWithFormat:@"field%d", row]; 
			NSString *fieldValue = [[NSString alloc] 
									initWithUTF8String:rowData]; 
			UITextField *field = [self valueForKey:fieldName]; 
			field.text = fieldValue; 
			[fieldName release]; 
			[fieldValue release]; 
		} 
		sqlite3_finalize(statement); 
	} 
	sqlite3_close(database); 
		
	
    UIApplication *app = [UIApplication sharedApplication]; 
    [[NSNotificationCenter defaultCenter] addObserver:self 
											 selector:@selector(applicationWillResignActive:) 
												 name:UIApplicationWillResignActiveNotification 
											   object:app]; 
    [super viewDidLoad]; 
} 
- (void)applicationWillResignActive:(NSNotification *)notification { 
    sqlite3 *database; 
    if (sqlite3_open([[self dataFilePath] UTF8String], &database) 
        != SQLITE_OK) { 
        sqlite3_close(database); 
        NSAssert(0, @"Nie udało się otworzyć bazy danych"); 
    } 
    for (int i = 1; i <= 4; i++) { 
        NSString *fieldName = [[NSString alloc] 
                               initWithFormat:@"field%d", i]; 
        UITextField *field = [self valueForKey:fieldName]; 
        [fieldName release]; 
		
        char *errorMsg; 
        // Warto zauważyć, że poniższe polecenie char powinno zostać zapisane w pojedynczym wierszu...  
        char *update = "INSERT OR REPLACE INTO FIELDS (ROW, FIELD_DATA) VALUES (?, ?);"; 
        sqlite3_stmt *stmt; 
        if (sqlite3_prepare_v2(database, update, -1, &stmt, nil) 
			== SQLITE_OK) { 
            sqlite3_bind_int(stmt, 1, i); 
            sqlite3_bind_text(stmt, 2, [field.text UTF8String], -1, NULL); 
        } 
        if (sqlite3_step(stmt) != SQLITE_DONE) 
            NSAssert1(0, @"Błąd podczas uaktualniania tabeli: %s", errorMsg); 
        sqlite3_finalize(stmt); 
		
    } 
    sqlite3_close(database); 	
} 

- (void)didReceiveMemoryWarning {
	// Jeżeli widok nie posiada widoku nadrzędnego, wówczas zostanie usunięty z pamięci.
    [super didReceiveMemoryWarning];
	
	// Usunięcie z pamięci wszelkich buforowanych danych, obrazów i innych zasobów, które obecnie nie są używane.
}

- (void)viewDidUnload {
	// Usunięcie wszystkich „przytrzymanych” podwidoków widoku głównego,
    // na przykład self.myOutlet = nil;
	self.field1 = nil; 
    self.field2 = nil; 
    self.field3 = nil; 
    self.field4 = nil; 
    [super viewDidUnload]; 
}


- (void)dealloc {
	[field1 release]; 
    [field2 release]; 
    [field3 release]; 
    [field4 release]; 	
    [super dealloc];
}

@end
